<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:fn="fn"
    xmlns:pl="http://product-live.com"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    version="3.0"
    exclude-result-prefixes="xs fn pl">
    
    <xsl:output method="xml" indent="yes" encoding="UTF-8" cdata-section-elements="" />
    
    <xsl:template match="/">
        <!-- All XML files must have a root element -->
        <example-loops>
            <!-- 1. List all ean in a <ean> element -->
            <eans>
                <xsl:for-each select="/Table/Items/Item">
                    <ean>
                        <!-- The XPath does not starts with / it is relative to the current node in context -->
                        <xsl:value-of select="Identifier[@key='ean']"/>
                    </ean>
                </xsl:for-each>
            </eans>

            <!-- 2. List all ean in a <ean> element ordered by price -->
            <eans-ordered-by-price>
                <xsl:for-each select="/Table/Items/Item">
                    <!--
                        xsl:sort must be used right after for-each
                        you must adapt the data-type depending the data, it can be text | number
                        order: ascending | descending
                    -->
                    <xsl:sort select="Field[@key='price']" order="ascending" data-type="number" />
                    <ean>
                        <xsl:value-of select="Identifier[@key='ean']"/>
                    </ean>
                </xsl:for-each>
            </eans-ordered-by-price>

            <!-- 3. List all ean grouped by typology -->
            <eans-grouped-by-typology>
                <xsl:for-each-group select="/Table/Items/Item" group-by="Classification[@key='typology']">
                    <xsl:variable name="typology" select="current-grouping-key()" />
                    <typology type="{$typology}">
                        <xsl:for-each select="current-group()">
                            <ean>
                                <xsl:value-of select="Identifier[@key='ean']"/>
                            </ean>
                        </xsl:for-each>
                    </typology>
                </xsl:for-each-group>
            </eans-grouped-by-typology>
        </example-loops>
    </xsl:template>
</xsl:stylesheet>